@echo off
setlocal

REM Set the path to the platform-tools directory
set PLATFORM_TOOLS_DIR=%~dp0platform-tools

REM Check if adb exists in the platform-tools directory
if not exist "%PLATFORM_TOOLS_DIR%\adb.exe" (
    echo ERROR: adb.exe not found in %PLATFORM_TOOLS_DIR%.
    pause
    exit /b 1
)

REM Set the APK file name
set APK_NAME=mr-sinbon-electronics.apk

REM Check if the APK file exists in the same directory as the batch file
if not exist "%~dp0%APK_NAME%" (
    echo ERROR: %APK_NAME% file not found.
    pause
    exit /b 1
)

:check_device
REM Check if a device is connected
"%PLATFORM_TOOLS_DIR%\adb.exe" devices | findstr /c:"device" >nul
if %errorlevel% neq 0 (
    "%PLATFORM_TOOLS_DIR%\adb.exe" devices | findstr /c:"unauthorized" >nul
    if %errorlevel% equ 0 (
        echo ERROR: Device unauthorized, please authorize on your device.
    ) else (
        echo ERROR: No device found, please connect your device.
    )
    timeout /t 5 >nul
    goto check_device
)

REM Execute adb install -r command
"%PLATFORM_TOOLS_DIR%\adb.exe" install -r "%~dp0%APK_NAME%"
if %errorlevel% neq 0 (
    echo Installation failed.
    pause
    exit /b 1
)

echo Installation successful.
pause
endlocal
exit /b 0
